using System;
using System.Web.UI.WebControls;
using System.Web.UI;
using System.ComponentModel;
using System.ComponentModel.Design;
using AjaxControlToolkit;

[assembly: System.Web.UI.WebResource("AnimatedImageRotator.AnimatedImageRotatorBehavior.js", "text/javascript")]

namespace AnimatedImageRotator
{
    [ParseChildren(true,"ImageList")]
    [PersistChildren(false)]
    [Designer(typeof(AnimatedImageRotatorDesigner))]
    [
        ClientScriptResource("AnimatedImageRotator.AnimatedImageRotatorBehavior",
            "AnimatedImageRotator.AnimatedImageRotatorBehavior.js")]
    [RequiredScript(typeof(AnimationScripts))]
    [TargetControlType(typeof(Image))]
    public class AnimatedImageRotatorExtender : ExtenderControlBase
    {
        [ExtenderControlProperty]
        [ClientPropertyName("rotationInterval")]
        [DefaultValue(3), DisplayName("RotationInterval(seconds))")]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)]
        public int RotationInterval
        {
            get { return GetPropertyValue<int>("RotationInterval", 3); }
            set { SetPropertyValue<int>("RotationInterval", value); }
        }

        private ImageUrlList _imageList;

        [ExtenderControlProperty]
        [ClientPropertyName("imageArray")]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
        [PersistenceMode(PersistenceMode.InnerDefaultProperty)]
        public ImageUrlList ImageList
        {
            get
            {
                if (_imageList == null)
                {
                    _imageList = GetPropertyValue<ImageUrlList>("ImageList", null);
                    if (_imageList == null)
                    {
                        _imageList = new ImageUrlList();
                        SetPropertyValue<ImageUrlList>("ImageList", _imageList);
                    }
                }
                return _imageList;
            }
        }
    }
}